/*
 * Decompiled with CFR 0.152.
 */
package com.articles.service;

import com.articles.repo.TopicRepo;
import com.articles.repo.domain.Chapter;
import com.articles.repo.domain.Topic;
import com.articles.service.TopicService;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class TransactionalTopicService
implements TopicService {
    private final TopicRepo topicRepo;

    public void addTopics(Topic topic) {
        Optional existingTopic = this.topicRepo.findById((Object)topic.getId());
        existingTopic.ifPresent(value -> topic.addTopics(value.getTopics()));
        this.topicRepo.save((Object)topic);
    }

    public Topic getById(Chapter id) {
        return this.topicRepo.findById((Object)id).orElse(Topic.empty());
    }

    public List<Topic> getAll() {
        return this.topicRepo.findAll();
    }

    public TransactionalTopicService(TopicRepo topicRepo) {
        this.topicRepo = topicRepo;
    }
}

