/*
 * Decompiled with CFR 0.152.
 */
package com.articles.core;

import com.articles.core.PromptComposer;
import com.articles.repo.domain.Chapter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TextGenFactory {
    private final RestTemplate rest;
    private final PromptComposer promptComposer;
    private final String url = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent";
    private final String keyArgument = "?key=";
    @Value(value="${gemini}")
    private String gemini;

    public String generateText(Chapter topic) {
        String[] prompt = this.promptComposer.composeByTopic(topic);
        if (prompt.length < 1) {
            return "";
        }
        String fullUrl = "https://generativelanguage.googleapis.com/v1beta/models/gemini-2.0-flash:generateContent?key=" + this.gemini;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity entity = new HttpEntity((Object)this.composeBody(prompt), (MultiValueMap)headers);
        ResponseEntity response = this.rest.exchange(fullUrl, HttpMethod.POST, entity, String.class, new Object[0]);
        return (String)response.getBody();
    }

    private String composeBody(String[] prompt) {
        return "{\n\"system_instruction\": {\n      \"parts\": [\n        {\n          \"text\": \n" + prompt[0] + "        }\n      ]\n    },    \"contents\": [\n      {\n        \"parts\": [\n          {\n            \"text\": " + prompt[1] + "          }\n        ]\n      }\n    ]\n\"generationConfig\": {\"thinkingConfig\": {\"thinkingBudget\": 0}}  }";
    }

    public TextGenFactory(RestTemplate rest, PromptComposer promptComposer) {
        this.rest = rest;
        this.promptComposer = promptComposer;
    }
}

