<!DOCTYPE html>
<html lang="en">
<head>
    <meta name="google-adsense-account" content="ca-pub-2987349950092151">
    <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-2987349950092151"
            crossorigin="anonymous"></script>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-2T14VYZV0D"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag() { dataLayer.push(arguments); }
        gtag('js', new Date());
        gtag('config', 'G-2T14VYZV0D');
    </script>

    <link rel="icon" href="/favicon.png" type="image/png">
    <meta charset="UTF-8">
    <title>These Topiqs Articles - Your Guide to ${chapter}</title>
    <meta name="description" content="Find all articles on ${chapter} topics from Topiqs.
    Explore in-depth guides, news, and analyses on ${chapter}.">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="canonical" href="https://topiqs.net/articles/chapter/${chapter}">

    <link rel="stylesheet" href="/css/articles-by-chapter.css">
</head>
<body>

<!-- Google Tag Manager (noscript) -->
<noscript>
    <iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WBMFZ324"
            height="0" width="0" style="display:none;visibility:hidden"></iframe>
</noscript>
<!-- End Google Tag Manager (noscript) -->

<div class="container">

    <!-- ✅ Sidebar copied from second template -->
    <div class="sidebar">

        <img src="/images/${chapter}.jpeg" alt="${chapter}" width="220" height="220">

        <h2>Topiqs</h2>
        <ul>
            <#list chapters as chapter>
                <a href="/articles/chapter/${chapter.chapter}" class="chapter-link">
                    <img src="/images/${chapter.chapter}.jpeg" alt="${chapter.chapter}" width="30" height="30">
                    <span class="chapter-label">${chapter.chapterAndCount}</span>
                </a>
            </#list>
        </ul>
    </div>

    <!-- ✅ Main content -->
    <div class="content">
        <h1>All Articles on ${chapter}</h1>
        <ul style="list-style: none; padding: 0;">
            <#list articles as article>
                <li style="margin: 10px 0;">
                    <h3>
                        <a href="/articles/${article.id}" style="color: #0057e7; text-decoration: none;">
                            ${article.title}
                        </a>
                    </h3>
                </li>
            </#list>
        </ul>

        <a href="/" class="home-button"> <<< Home</a>

        <footer>
            &copy; ${.now?string("yyyy")} Helpful articles :)
        </footer>
    </div>
</div>

</body>
</html>
